/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.pipes.EncasedPipeBlock;
import com.zurrtum.create.content.fluids.pipes.FluidPipeBlock;
import com.zurrtum.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class FluidPipeBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public FluidPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static FluidPipeBlockEntity pipe(class_2338 pos, class_2680 state) {
        return new FluidPipeBlockEntity(AllBlockEntityTypes.FLUID_PIPE, pos, state);
    }

    public static FluidPipeBlockEntity encased(class_2338 pos, class_2680 state) {
        return new FluidPipeBlockEntity(AllBlockEntityTypes.ENCASED_FLUID_PIPE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new StandardPipeFluidTransportBehaviour(this, this));
        behaviours.add(new BracketedBlockEntityBehaviour(this, this::canHaveBracket));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        BracketedBlockEntityBehaviour bracketBehaviour = this.getBehaviour(BracketedBlockEntityBehaviour.TYPE);
        if (bracketBehaviour != null) {
            bracketBehaviour.transformBracket(transform);
        }
    }

    private boolean canHaveBracket(class_2680 state) {
        return !(state.method_26204() instanceof EncasedPipeBlock);
    }

    class StandardPipeFluidTransportBehaviour
    extends FluidTransportBehaviour {
        public StandardPipeFluidTransportBehaviour(FluidPipeBlockEntity this$0, SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return (FluidPipeBlock.isPipe(state) || state.method_26204() instanceof EncasedPipeBlock) && (Boolean)state.method_11654((class_2769)FluidPipeBlock.field_11329.get(direction)) != false;
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            class_2338 offsetPos = pos.method_10093(direction);
            class_2680 otherState = world.method_8320(offsetPos);
            if (state.method_26204() instanceof EncasedPipeBlock && attachment != FluidTransportBehaviour.AttachmentTypes.DRAIN) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                FluidTransportBehaviour pipeBehaviour;
                if (!FluidPipeBlock.isPipe(otherState) && !(otherState.method_26204() instanceof EncasedPipeBlock) && !(otherState.method_26204() instanceof GlassFluidPipeBlock) && (pipeBehaviour = BlockEntityBehaviour.get((class_1922)world, offsetPos, FluidTransportBehaviour.TYPE)) != null && pipeBehaviour.canHaveFlowToward(otherState, direction.method_10153())) {
                    return FluidTransportBehaviour.AttachmentTypes.DETAILED_CONNECTION;
                }
                if (!FluidPipeBlock.shouldDrawRim(world, pos, state, direction)) {
                    return FluidPropagator.getStraightPipeAxis(state) == direction.method_10166() ? FluidTransportBehaviour.AttachmentTypes.CONNECTION : FluidTransportBehaviour.AttachmentTypes.DETAILED_CONNECTION;
                }
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.NONE && ((Boolean)state.method_11654((class_2769)FluidPipeBlock.field_11329.get(direction))).booleanValue()) {
                return FluidTransportBehaviour.AttachmentTypes.DETAILED_CONNECTION;
            }
            return attachment;
        }
    }
}

